% Author: Layla S. Mayboudi
% 2021-05-27
% This codes checks if the input is within specified limits and returns the
% entered output value.

% Note:
% This code is the function used by the code random_walk_plot.m.

% Inputs:
% propName = character array with material property name
% propUnits = character array with material property units
% lowerLimit = number defining property lower limit
% upperLimit = number defining property upper limit

% Outputs:
% outValue = property value entered by user
% outIndx = indicates if the value is below lower limit (1); between limits (2);
% or above upper limit (3)


function [outValue,outIndx] = testPropLimits(propName,propUnits,lowerLimit,upperLimit)

if not(isnumeric(lowerLimit)) || not(isnumeric(upperLimit))
    error('Lower and upper limits must be numbers.')
end
if not(ischar(propName)) || not(ischar(propUnits))
    error('Property name and units must be character arrays.')
end
if lowerLimit >= upperLimit
    error('Property lower limit must be less than upper limit.')
end

lowIndx = 1; okIndx = 2; highIndx = 3;
done = false; outIndx = 0;
while not(done)
    outValue = input(['Enter ' propName ' value between ' num2str(lowerLimit)...
        ' and ' num2str(upperLimit) ' (' propUnits '): ']);
    if outValue<lowerLimit
        disp(['WARNING: Entered ' propName ' is less than lower limit of '...
            num2str(lowerLimit) ' ' propUnits])
        outIndx = lowIndx;
    elseif outValue>upperLimit
        disp(['WARNING: Entered ' propName ' is greater than upper limit of '...
            num2str(upperLimit) ' ' propUnits])
        outIndx = highIndx;
    else
        outIndx = okIndx;
    end
    if outIndx ~= okIndx
        yourAnswer=input(['Enter new value (y/n)? (n=default)'],'s');
        % if no value is entered, default to keep same value
        if isempty(yourAnswer)
            yourAnswer='n';
        end
        if (yourAnswer(1)=='y') || (yourAnswer(1)=='Y')
            done=false;
        else
            done=true;
        end
    else
        done=true;
    end
end %while
end %function